#include "main.h"

GLfloat texpts[2][2][2] = {{{0.0, 0.0}, {0.0, 1.0}},
          {{1.0, 0.0}, {1.0, 1.0}}};

GLfloat grid4x4[4][4][3] =
{
  {
    {-2.0, -2.0, 0.0},
    {-0.5, -2.0, 0.0},
    {0.5, -2.0, 0.0},
    {2.0, -2.0, 0.0}},
  {
    {-2.0, -0.5, 0.0},
    {-0.5, -0.5, 0.0},
    {0.5, -0.5, 0.0},
    {2.0, -0.5, 0.0}},
  {
    {-2.0, 0.5, 0.0},
    {-0.5, 0.5, 0.0},
    {0.5, 0.5, 0.0},
    {2.0, 0.5, 0.0}},
  {
    {-2.0, 2.0, 0.0},
    {-0.5, 2.0, 0.0},
    {0.5, 2.0, 0.0},
    {2.0, 2.0, 0.0}}
};

GLfloat *grid = &grid4x4[0][0][0];
int uSize = 4;
int vSize = 4;
int gridSize = 20;


void setupMesh(void){
  glEnable(GL_MAP2_VERTEX_3);
  glEnable(GL_MAP2_TEXTURE_COORD_2);
  glMapGrid2f(gridSize, 0.0, 1.0, gridSize, 0.0, 1.0);
}

void evaluateGrid(void){
  glColor3f(1.0, 1.0, 1.0);
  glMap2f(GL_MAP2_VERTEX_3, 0, 1, 3, uSize, 0, 1, uSize * 3, vSize, grid);
      
  glMap2f(GL_MAP2_TEXTURE_COORD_2, 0, 1, 2, 2, 0, 1, 4, 2, &texpts[0][0][0]);

  glEvalMesh2(GL_FILL, 0, gridSize, 0, gridSize);
}



